'use strict';

/* Controllers */
function BCPBankCtrl($scope, $rootScope, Company, BanksList, RoundsManager){

    Company.init();
    $scope.company =  Company;
//    console.log($scope.company);

    $scope.bankServices = $scope.company.bank_service_options;
    $scope.msg;
    $scope.transferAmount;
    $scope.creditPercent;

    $scope.changes;
    $scope.methodType = 'bcp-bank';
    $scope.number = /^\d+$/;

    $scope.init = function() {
        $scope.account = BanksList.getCurrentAccount();

        $scope.changes = [];
        $scope.msg = '';
        $scope.transferAmount = 0;
        $scope.creditPercent = 0.97;
    }

    $scope.isUsedOptionsForBankService = function(bankService) {
        return bankService.isUsed();
    }

    $scope.isUsedOption = function(option) {
        return ($scope.company.bank_service_options.filter(function(bankServiceOption){return bankServiceOption.id == option.id}).length > 0)
    }

    $scope.checkOption = function(option, rowNumber) {
        option.checked = (option.checked) ? false : rowNumber;                 
    }

    $scope.showBankServiceOptionsList = function() {
        var params = {};
        $rootScope.$broadcast('Bank:openBankOffersModal', params);
    }

    $scope.showTransferError = function(msg, title) {
        if(!title){
            $scope.title = "Błąd wykonania przelewu";
        }else{
            $scope.title = title;
        }
        $scope.msg = msg;
        angular.element('#modal-transfer-error').modal('show');
    }

    $scope.transfer = function() {
        var transferAmount = Number($scope.transferAmount);
        var bankService = $scope.company.bank_service_options.filter(function(option){return option.checked == 1 || option.checked == 2})
        
        if(bankService.length != 2){
            $scope.showTransferError('Wybierz poprawnie źródło i cel przelewu.');

        }else if( !transferAmount || transferAmount <= 0){
            $scope.showTransferError('Podaj poprawną kwotę przelewu.');

        }else{
            var source = bankService.filter(function(check){return check.checked == 1});
            var target = bankService.filter(function(check){return check.checked == 2});

            if(transferAmount > source[0].value || transferAmount > target[0].value){
                $scope.showTransferError('Podana kwota przewyższa wartość dostępnych środków lub wartość zadłużenia!');

            }else if(transferAmount == target[0].value){
                source[0].value -= transferAmount;
                target[0].value -= transferAmount;

                var params = {};
                params.title = 'Likwidacja produktu bankowego';
                params.msg = 'Kredy został spłacony i zostanie zlikwidowany.';
                $scope.currentProductToRemove = target[0];
                $scope.$broadcast('BankProduct:openRemoveBankProductModal', params);


            }else{
                source[0].value -= transferAmount;
                //jest odejmowanie, bo przelewy są wyłącznie na spłatę kredytu
                target[0].value = target[0].value - transferAmount;

                $scope.changes.push('Przelano kwotę ' + transferAmount 
                    + 'zł z ' + source[0].option.bank_service.name + ' '
                    +  source[0].option.name + ' na ' + target[0].option.bank_service.name
                    + ' ' + target[0].option.name + '.'
                );
                $scope.account[0].option.cost += 2;
            }
        }
    }

    $scope.showToken = function() {
        var params = {};
        params.title = 'Finanse';
        params.tokensConfirmsMessage = 'controlPanel,bank';
        params.typeSubmitToken = 'REPRESENTATION';
        params.changes = [];
        angular.forEach($scope.bankServices, function(BankService){
            angular.forEach(BankService.types, function(BankServiceOption){
                if(BankServiceOption.flags != 'RB')
                {
                    angular.forEach(BankServiceOption.getChanged(), function(cbso){
                        if(cbso.isDeleted())
                        {
                            params.changes.push(BankServiceOption.name + ': usunięcie opcji o wysokości ' + cbso._originalValue + ' zł');
                        }
                        else if(cbso._operation == 'MODIFY_LOAN'){
                            params.changes.push(BankServiceOption.name + ': ustawienie nowej kwoty ' + cbso.value + ' zł');
                        }
                        else
                        {
                            params.changes.push(BankServiceOption.name + ': dodanie opcji o wysokości ' + cbso.value + ' zł');
                        }
                    });
                }
            });
        })
        params.modal = true;

        $rootScope.$broadcast('Tokens:openSubmitTokensModal',$scope.company, params, $scope.methodType);
//        $rootScope.$broadcast('Tokens:closeSubmitTokensModal',$scope.methodType);
    }

    $scope.$on('Tokens:closeSubmitTokensModal', function(event,methodType){
        if(methodType == $scope.methodType)
        {
            angular.forEach($scope.bankServices, function(BankService){
                angular.forEach(BankService.getAllChanges(), function(object){
                    object.cbso.save(function(cbso){
                        if(cbso.id == null)
                        {
                            object.option.company_bank_service_options.splice(object.option.company_bank_service_options.indexOf(cbso), 1);
                        }
                    });
                });
            })
        }
    });

    $scope.removeProduct = function() {
        for(var i = 0; i < $scope.company.bank_service_options.length; i++)
        {
            if($scope.company.bank_service_options[i].option.id == $scope.currentProductToRemove.option.id){
                $scope.changes.push('Zlikwidowano produkt ' + $scope.currentProductToRemove.option.name + '.');
                $scope.account[0].value += Number($scope.currentProductToRemove.value);
                $scope.company.bank_service_options.splice(i, 1);
                break;
            }
        }
    }

    /**
     * Otwarcie okna i przekazanie inofrmacji która pozycja z jakiej opcji ma zostać ewentualnie usunieta
     * @param option
     * @param cbso
     */
    $scope.showRemoveInvestment = function(BankService, option, cbso) {
        $rootScope.$broadcast('Bank:openRemoveInvestmentModal', {
            BankService: BankService
            ,option: option
            ,cbso: cbso
        });
    }

    $scope.increaseVal = function() {
        $scope.transferAmount = Number($scope.transferAmount) + 1;
    }

    $scope.decreaseVal = function() {
        $scope.transferAmount = Number($scope.transferAmount) - 1;
    }


    /**
     * TU DOPISUJĘ SOWJE FUNKCJE - RAFAŁ
     */
    $scope.isChanged = function(){
        return BanksList.isChanged();
    }


    $scope.showDetails = function(cbso){
        $rootScope.$broadcast('Chattel:openAccountDetails', cbso);
    }

    $scope.repayLoan = function(cbso){
        $rootScope.$broadcast('Chattel:repayLoan', cbso);
    }

    $scope.modifyLoan = function(cbso){
        $rootScope.$broadcast('Chattel:modifyLoan', cbso);
    }

    /**
     * Sprawdza czy dana pozycje można spłacać
     * @param cbso
     * @returns {boolean}
     */
    $scope.isAbleToRepay = function(cbso){
        return cbso.round_id != roundId && cbso.value > 0;
    }

    /**
     * Podejrzenie historii zmian jest mozliwe tylko wtedy gdy dane nie byly na danym trachunku zmienione
     * @param cbso
     * @returns {boolean}
     */
    $scope.isEnableHistory = function(cbso){
        return cbso._originalValue == cbso.value;
    }


    $scope.getRoundSequence = function(roundId){
        return RoundsManager.getRoundSequence(roundId);
    }
}

BCPBankCtrl.$inject = ['$scope', '$rootScope', 'Company', 'BanksList', 'RoundsManager'];

BCPBankCtrl.getCompanyForLoggedUser = function($q, $route, $rootScope, FrontCreatorCompanyForLoggedUser){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorCompanyForLoggedUser.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

BCPBankCtrl.getBankServices = function($q, $route, $rootScope, FrontCreatorBankServices){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorBankServices.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}